/**
 * Copyright 2015 Ministerio de Industria, Energía y Turismo
 *
 * Este fichero es parte de "Facturae-APC".
 *
 * Licencia con arreglo a la EUPL, Versión 1.1 o –en cuanto sean aprobadas por la Comisión Europea– versiones posteriores de la EUPL (la Licencia);
 * Solo podrá usarse esta obra si se respeta la Licencia.
 *
 * Puede obtenerse una copia de la Licencia en:
 *
 * http://joinup.ec.europa.eu/software/page/eupl/licence-eupl
 *
 * Salvo cuando lo exija la legislación aplicable o se acuerde por escrito, el programa distribuido con arreglo a la Licencia se distribuye «TAL CUAL»,
 * SIN GARANTÍAS NI CONDICIONES DE NINGÚN TIPO, ni expresas ni implícitas.
 * Véase la Licencia en el idioma concreto que rige los permisos y limitaciones que establece la Licencia.
 */
package es.mityc.appfacturae.facturae;
 
public enum CurrencyCodeType {

    AFN,
    ALL,
    AMD,
    ANG,
    AOA,
    ARS,
    AUD,
    AWG,
    AZN,
    BAD,
    BBD,
    BDT,
    BGN,
    BHD,
    BIF,
    BMD,
    BND,
    BOB,
    BRL,
    BRR,
    BSD,
    BWP,
    BYR,
    BZD,
    CAD,
    CDF,
    CDP,
    CHF,
    CLP,
    CNY,
    COP,
    CRC,
    CUP,
    CVE,
    CZK,
    DJF,
    DKK,
    DOP,
    DRP,
    DZD,
    EEK,
    EGP,
    ESP,
    ETB,
    EUR,
    FJD,
    FKP,
    GBP,
    GEK,
    GHC,
    GIP,
    GMD,
    GNF,
    GTQ,
    GWP,
    GYD,
    HKD,
    HNL,
    HRK,
    HTG,
    HUF,
    IDR,
    ILS,
    INR,
    IQD,
    IRR,
    ISK,
    JMD,
    JOD,
    JPY,
    KES,
    KGS,
    KHR,
    KMF,
    KPW,
    KRW,
    KWD,
    KYD,
    KZT,
    LAK,
    LBP,
    LKR,
    LRD,
    LSL,
    LTL,
    LVL,
    LYD,
    MAD,
    MDL,
    MGF,
    MNC,
    MNT,
    MOP,
    MRO,
    MUR,
    MVR,
    MWK,
    MXN,
    MYR,
    MZM,
    NGN,
    NIC,
    NIO,
    NIS,
    NOK,
    NPR,
    NZD,
    OMR,
    PAB,
    PEI,
    PEN,
    PES,
    PGK,
    PHP,
    PKR,
    PLN,
    PYG,
    QAR,
    RMB,
    RON,
    RUB,
    RWF,
    SAR,
    SBD,
    SCR,
    SDP,
    SEK,
    SGD,
    SHP,
    SKK,
    SLL,
    SOL,
    SOS,
    SRD,
    STD,
    SVC,
    SYP,
    SZL,
    THB,
    TJS,
    TMM,
    TND,
    TOP,
    TPE,
    TRY,
    TTD,
    TWD,
    TZS,
    UAH,
    UGS,
    USD,
    UYP,
    UYU,
    VEF,
    VND,
    VUV,
    WST,
    XAF,
    XCD,
    XOF,
    YER,
    ZAR,
    ZMK,
    ZWD;

    public String value() {
        return name();
    }

    public static CurrencyCodeType fromValue(String v) {
        return valueOf(v);
    }

}
