/**
 * Copyright 2015 Ministerio de Industria, Energía y Turismo
 *
 * Este fichero es parte de "Facturae-APC".
 *
 * Licencia con arreglo a la EUPL, Versión 1.1 o –en cuanto sean aprobadas por la Comisión Europea– versiones posteriores de la EUPL (la Licencia);
 * Solo podrá usarse esta obra si se respeta la Licencia.
 *
 * Puede obtenerse una copia de la Licencia en:
 *
 * http://joinup.ec.europa.eu/software/page/eupl/licence-eupl
 *
 * Salvo cuando lo exija la legislación aplicable o se acuerde por escrito, el programa distribuido con arreglo a la Licencia se distribuye «TAL CUAL»,
 * SIN GARANTÍAS NI CONDICIONES DE NINGÚN TIPO, ni expresas ni implícitas.
 * Véase la Licencia en el idioma concreto que rige los permisos y limitaciones que establece la Licencia.
 */
package es.mityc.appfacturae.utils.io;

import java.awt.event.KeyEvent;
import java.text.BreakIterator;
import java.text.DecimalFormat;



public class StringUtil {
	/*public static String wordWrap(String s, int n){
		if (s != null){
			String copy = new String(s);
			String result = "";
			while (copy.length() >= 0){
				if (copy.length() < n){
					return result + copy;
				}
				else{
					result = result + copy.substring(0, n) + "\n";
					copy = copy.substring(n,copy.length());
				}
			}
		}
		return "";
	}*/
	
    /**
     * Reformats a string where lines that are longer than <tt>width</tt>
     * are split apart at the earliest wordbreak or at maxLength, whichever is
     * sooner. If the width specified is less than 5 or greater than the input
     * Strings length the string will be returned as is.
     * <p/>
     * Please note that this method can be lossy - trailing spaces on wrapped
     * lines may be trimmed.
     *
     * @param input the String to reformat.
     * @param width the maximum length of any one line.
     * @return a new String with reformatted as needed.
     */
    public static String wordWrap(String input, int width) {
        // protect ourselves
        if (input == null) {
            return "";
        }
        else if (width < 5) {
            return input;
        }
        else if (width >= input.length()) {
            return input;
        }

  

        StringBuilder buf = new StringBuilder(input);
        boolean endOfLine = false;
        int lineStart = 0;

        for (int i = 0; i < buf.length(); i++) {
            if (buf.charAt(i) == '\n') {
                lineStart = i + 1;
                endOfLine = true;
            }

            // handle splitting at width character
            if (i > lineStart + width ) {
                if (!endOfLine) {
                    int limit = i - lineStart - 1;
                    BreakIterator breaks = BreakIterator.getLineInstance();
                    breaks.setText(buf.substring(lineStart, i));
                    int end = breaks.last();

                    // if the last character in the search string isn't a space,
                    // we can't split on it (looks bad). Search for a previous
                    // break character
                    if (end == limit + 1) {
                        if (!Character.isWhitespace(buf.charAt(lineStart + end))) {
                            end = breaks.preceding(end - 1);
                        }
                    }

                    // if the last character is a space, replace it with a \n
                    if (end != BreakIterator.DONE && end == limit + 1) {
                        buf.replace(lineStart + end, lineStart + end + 1, "\n");
                        lineStart = lineStart + end;
                    }
                    // otherwise, just insert a \n
                    else if (end != BreakIterator.DONE && end != 0) {
                        buf.insert(lineStart + end, '\n');
                        lineStart = lineStart + end + 1;
                    }
                    else {
                        buf.insert(i, '\n');
                        lineStart = i + 1;
                    }
                }
                else {
                    buf.insert(i, '\n');
                    lineStart = i + 1;
                    endOfLine = false;
                }
            }
        }

        return buf.toString();
    }	
	public static boolean isSpecialCharWindows(char c){
		int charNum = (new Integer(c)).intValue();
		if (charNum == KeyEvent.VK_BACK_SLASH ||
			charNum == KeyEvent.VK_SLASH ||
			charNum == (new Integer(':')).intValue() ||
			charNum == (new Integer('*')).intValue() ||
			charNum == (new Integer('?')).intValue() ||
			charNum == (new Integer('"')).intValue() ||
			charNum == (new Integer('<')).intValue() ||
			charNum == (new Integer('>')).intValue() ||
			charNum == (new Integer('|')).intValue())
			return true;
		else
			return false;
	}
	
	public static String getSpecialCharsWindows(){
		return "\\ / : * ? \" < > |";
	}
	
	public static String disableScientificNotation(Double value, int decimals){
		DecimalFormat decimalFormatter = new DecimalFormat("#########################.########");
		return decimalFormatter.format(Double.parseDouble(DoubleUtil.formatDecimal(value, decimals))).replace(",", ".");
	}
	
	public static String disableScientificNotation(String value, int decimals){
		return disableScientificNotation(Double.valueOf(value.replace(",",".")),decimals).replace(",", ".");
	}
}
